<?php

namespace App\Http\Resources;

use App\Models\Account;
use App\Models\Client;
use App\Models\Employee;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BoundEntriesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'entry_type' => substr($this->entry_type, strrpos($this->entry_type, '\\') + 1),
            'entry_id' => $this->entry_id,
            'value' => $this->value,
            'note' => $this->note,
        ];
    }
}
