<?php

namespace App\Http\Resources;

use App\Models\Account;
use App\Models\Client;
use App\Models\Employee;
use App\Models\Supplier;
use Illuminate\Http\Resources\Json\JsonResource;

class BoundResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'description' => $this->description,
            'ref_number' => $this->ref_number,
            'voucher_type' => $this->voucher_type,
            'branch_id' => $this->branch_id,
            'payment_id' => $this->whenLoaded('payment', function () {
                return $this->payment->id;
            }),
            'payment_method_id' =>  $this->whenLoaded('paymentMethod', function () {
                return $this->paymentMethod->id;
            }),
            'bound_entries' =>  BoundEntriesResource::collection($this->whenLoaded('boundEntries')),
            'bills' => $this->whenLoaded('bills', function () {
                return $this->bills;
                // $this->bills->map(function ($bill) {
                    
                //     return [
                //         'bill_id'  => $bill->id,
                //         'bill'  => $bill,
                //         'amount'   => $bill->pivot->amount,
                //         'discount' => $bill->pivot->discount,
                //     ];
                // });
            }),
            'status' =>  $this->status,
        ];
    }
}
