<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BranchResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'] ?? '',
            'phone_1' => $this->phone_1,
            'phone_2' => $this->phone_2,
            'email' => $this->email,
            'website' => $this->website,
            'delivers' => $this->delivers,
            'opening_time' => $this->opening_time,
            'closing_time' => $this->closing_time,
            'is_opened' => $this->is_opened,
            'status' => $this->status,
            'number_of_employees' => $this->number_of_employees,
            'address' => new AddressResource($this->whenLoaded('address')),
            "area" => $this->area ?? "",
            "location" => $this->location,
            'group_settings_id' => $this->group_settings_id,
            'treasuries' => TreasuryResource::collection($this->whenLoaded('treasuries')),
            'networks' => NetworkResource::collection($this->whenLoaded('networks')),
            'banks' => BankResource::collection($this->whenLoaded('banks')),
            'custodies' => CustodyResource::collection($this->whenLoaded('custodies')),
            'employees' => EmployeeResource::collection($this->whenLoaded('employees')),
            'warehouses' => WarehouseResource::collection($this->whenLoaded('warehouses')),
            'deliveries' => DeliveryResource::collection($this->whenLoaded('deliveries')),
            'sell_natures' => $this->whenLoaded('company', function () {
                return SellNatureResource::collection($this->company->sellNatures);
            }),
            'services' => ServiceResource::collection($this->whenLoaded('services')),
            'products' => ProductBranchResource::collection($this->whenLoaded('products')),

        ];
    }
}
