<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanyRevenuesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'date' => $this->date,
            'client_name' => $this->client_name,
            'phone' => $this->phone,
            'city' => $this->city,
            'network' => $this->network,
            'cash' => $this->cash,
            'transfer' => $this->transfer,
            'electronic' => $this->electronic,
            'wallet' => $this->wallet,
            'tap' => $this->tap,
            'stc' => $this->stc,
            'mada' => $this->mada,
            'delivery_cost' => $this->delivery_cost,
            'total_without_taxes' => $this->total_without_taxes,
            'tax' => $this->tax,
            'total' => $this->total,
        ];
    }
}
