<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DismissalNoticeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'use_quantity' => $this->use_quantity,
            'product' => ProductResource::make($this->whenLoaded('product')),
            'warehouse' => WarehouseResource::make($this->whenLoaded('warehouse')),
            'branch' => BranchResource::make($this->whenLoaded('branch')),
        ];
    }
}
