<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EmployeeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "code" => $this->code,
            "address" => new AddressResource($this->whenLoaded('address')),
            "name" => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'] ?? '',
            'name_en' => $this->getTranslations('name')['en'] ?? '',
            "phone" => $this->phone,
            "email" => $this->email,
            "birth_date" => $this->birth_date,
            "identity_type" => $this->identity_type,
            "ID_number" => $this->ID_number,
            "hiring_date" => $this->hiring_date,
            "status" => $this->status ? 'on' : 'off',
            "online" => $this->online ? 'on' : 'off',
            "calendar_appearance" => $this->calendar_appearance ? 'on' : 'off',
            "attendance_method_id" => $this->attendance_method_id,
            "section_id" => $this->section_id,
            "career_id" => $this->career_id,
            "attendance_method" => new AttendanceMethodResource($this->whenLoaded('attendanceMethod')),
            "section" => new CareerSectionResource($this->whenLoaded('section')),
            "career" => new CareerSectionResource($this->whenLoaded('career')),
            "branches" => $this->branches()->pluck('branches.id'),
        ];
    }
}
