<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EmployeeTransactionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'employee' => $this->employee->name,
            'from_branch' => $this->fromBranch->name,
            'to_branch' => $this->toBranch->name,
            'temporary' => $this->temporary ? 'on' : 'off',
            'end_date' => $this->end_date,
        ];
    }
}
