<?php

namespace App\Http\Resources;

use AddBarcodeToProductUnitTable;
use App\Models\Product;
use App\Models\ProductUnit;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InventoryProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [

            'product_id' => $this->product_id,
            'actual_quantity' => $this->actual_quantity,
            'diff_quantity' => $this->diff_quantity,
            'product' => ProductResource::make($this->whenLoaded('product')),
            'quantity' => $this->getProductQuantity(),
            'price' =>ProductUnit::where('product_id' , $this->product->id)->first()->purchasing_price,
        ];
    }
}
