<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InventoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'description' => $this->description,
            'date' => $this->date,
            'status' => $this->status,
            'products' => InventoryProductResource::collection($this->whenLoaded('products')),
            'warehouse_id' => $this->warehouse_id,
            'warehouse_name' => $this->warehouse->name,
        ];
    }
}
