<?php

namespace App\Http\Resources;

use App\Models\Journal;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class JournalRepeationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "desc" => $this->desc,
            "start_date" => $this->start_date,
            "end_date" => $this->end_date,
            "period" => $this->period,
            "is_expired" => $this->is_expired,
            "journal" =>JournalResource::make($this->journal),
        ];
    }
}
