<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class JournalResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'quantity_with_unit' => $this->whenLoaded('journalable', function () {
                $quantityWithUnit = [];

                if ($this->journalable->billProducts?->first()?->quantity) {
                    $quantityWithUnit = [
                        'quantity' => $this->journalable->billProducts?->first()?->quantity,
                        'unit' => new UnitResource($this->journalable->billProducts?->first()?->unit),
                    ];
                } elseif ($this->journalable->quantity) {
                    $quantityWithUnit = [
                        'quantity' => $this->journalable->quantity,
                        'unit' => null,
                    ];
                }

                return $quantityWithUnit;
            }),
            'reference_code' => $this->reference_code,
            'type' => $this->type,
            'source' => $this->source,
            'description' => $this->description,
            'file' => $this->file,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'journalable' => $this->whenLoaded('journalable'),
            'employee' => EmployeeResource::make($this->whenLoaded('employee')),
            'branch' => BranchResource::make($this->whenLoaded('branch')),
            'branch_id' => $this->branch_id,
            'warehouse' => WarehouseResource::make($this->whenLoaded('warehouse')),
            'entries' => EntryResource::collection($this->whenLoaded('entries')),
            'journalRepeation' => JournalRepeationResource::collection($this->whenLoaded('journalRepeation')),
            'files' => $this->whenLoaded('files', function () {
                return $this->files->map(function ($file) {
                    return [
                        'id' => $file->id,
                        'journal_id' => $file->journal_id,
                        'file' => $file->file,
                        'reference_number' => $file->reference_number,
                        'created_at' => $file->created_at,
                        'updated_at' => $file->updated_at,
                    ];
                });
            }),
            'total_amount' => $this->whenLoaded('entries', function () {
                // return $this->entries->sum('amount') / 2;
                return round($this->entries->sum('amount') / 2, 2);
            }),
        ];
    }
}
