<?php

namespace App\Http\Resources;

use App\Http\Helper\CompanyHelper;
use App\Http\Resources\AccountModelResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ModelGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'key' => $this->getTranslation('name', 'en'),
            'models' => AccountModelResource::collection(
                $this->whenLoaded('mainModels', function () {
                    // Pass the current ModelGroup to the AccountModelResource
                    return $this->mainModels->map(function ($mainModel) {
                        return $mainModel->load(['accounts' => function ($query) {
                            $query->wherePivot('group_id', $this->id);
                            $query->wherePivot('company_id', CompanyHelper::getId());
                        }]);
                    });
                })
            ),
        ];
    }
}
