<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OpenBalanceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'products' => OpenBalanceProductsResource::collection($this->whenLoaded('products')),
            'branch' => BranchResource::make($this->whenLoaded('branch')),
            'warehouse' => WarehouseResource::make($this->whenLoaded('warehouse')),
            'description' => $this->description,
            'date' => $this->date,
            'status' => $this->status,
        ];
    }
}
