<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'] ?? '',
            'name_en' => $this->getTranslations('name')['en'] ?? '',
            'price' => $this->price,
            'type' => $this->type,
            'free' => $this->free,
            'status' => $this->status,
            'features' => FeatureResource::collection($this->whenLoaded('features')),
            'period' => $this->period,
        ];
    }
}
