<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductBranchResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "product_id" => $this->product_id,
            "branch_id" => $this->branche_id,
            "branch" => $this->whenLoaded('branch', function () {
                return $this->branch->name;
            }),
            'product' => new ProductResource($this->whenLoaded('product')),
            "min_quantity" => $this->min_quantity,
            "max_quantity" => $this->max_quantity,
            "quantity" => $this->quantity,
            "price" => number_format($this->price, 2),
            "open_balance_price" => number_format($this->open_balance_price, 2),
            "open_balance_quantity" => $this->open_balance_quantity,
            'units' => BrancUnithResource::collection($this->whenLoaded('branchUnits')),

        ];
    }
}
