<?php

namespace App\Http\Resources;

use App\Models\ProductUnit;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductQuantityTrackResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            'quantity' => (float)$this->quantity,
            'product_id' => $this->product_id,
            'journal_id' => $this->journal_id,
            'product_unit_id' => $this->product_unit_id,
            'product_warehouse_id' => $this->product_warehouse_id,
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
            'journal' => JournalResource::make($this->whenLoaded('journal')),
            'product_unit' => ProductUnitResource::make($this->whenLoaded('productUnit')),
        ];
    }
}
