<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductUnitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "product_id" => $this->product_id,
            "unit_id" => $this->unit_id,
            "unit" =>$this->whenLoaded('unit', function () {
                return $this->unit->name;
            }),
            "barcode" => $this->barcode,

            "unit_name" => $this->whenLoaded('unit', function () {
                return $this->unit->name;
            }),
            "product_id" => $this->product_id,
            "main" => $this->main ? 'on' : 'off',
            "virtual_sale" => $this->virtual_sale ? 'on' : 'off',
            "virtual_buying" => $this->virtual_buying ? 'on' : 'off',
            "conversion_factor" => $this->conversion_factor,
            "purchasing_price" => $this->purchasing_price,
            "selling_price" => $this->selling_price,
            'last_selling_price' => $this->whenLoaded('lastSalesPrice', fn () => $this->lastSalesPrice->price),
            // 'last_purchase_price' => $this->whenLoaded('lastSalesPrice', fn () => $this->lastPurchasePrice->price),
            'last_purchase_price' =>$this->selling_price,
        ];
    }
}
