<?php

namespace App\Http\Resources;

use App\Http\Resources\ServiceBranchResource;
use App\Http\Resources\ServiceProductResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "code" => $this->code,
            "category_id" => $this->category_id,
            "name" => $this->name,
            "name_ar" => $this->getTranslations("name")["ar"],
            "name_en" => $this->getTranslations("name")["en"],
            "description" => $this->description,
            "description_ar" => isset($this->getTranslations("description")["ar"]) ? $this->getTranslations("description")["ar"] : '',
            "description_en" => isset($this->getTranslations("description")["en"]) ? $this->getTranslations("description")["en"] : '',
            "fast_service" => $this->fast_service,
            // "fast_service_id" => $this->fast_service_id,
            "second_employee" => $this->second_employee,
            "second_employee_rate" => $this->second_employee_rate,
            "time_type_id" => $this->time_type_id,
            "time_amount" => $this->time_amount,
            "calender_appearance" => $this->calender_appearance,
            "internet_description" => $this->internet_description,
            "details" => $this->details,
            "status" => $this->status,
            "processing" => $this->processing,
            "preparation_min" => $this->preparation_min,
            "finishing_min" => $this->finishing_min,
            "pricing_type" => $this->pricing_type,
            "price" => $this->price,
            "home_price" => $this->home_price,
            "products" => ServiceProductResource::collection($this->productServiceUnits),
            "branches" => ServiceBranchResource::collection($this->branches),
        ];
    }
}
