<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipmentItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'shipment_id' => $this->shipment_id,
            'cost' => $this->cost,
            'weight' => $this->weight,
            'tax' => new TaxResource($this->whenLoaded('tax')),
            'attachment' => $this->attachment,
            'quantity' => $this->quantity,
            'discount_type' => $this->discount_type,
            'discount' => $this->discount,
            'type' => new ShipmentItemTypeResource($this->whenLoaded('type')),
        ];
    }
}
