<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipmentItemTypeDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name_ar' => $this->getTranslation('name','ar'),
            'name_en' => $this->getTranslation('name','en'),
            'taxable' => $this->taxable,
            'container_price' => $this->container_price,
        ];
    }
}
