<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        $data = [
            'id' => $this->id,
            'tracking_code'  => $this->tracking_code,
            "key" => $this->key ==0 ? "offline" : "online",
            'sender' =>  new ClientResource($this->whenLoaded('sender')),
            'receiver' => new ShipmentReceiverResource($this->whenLoaded('receiver')),
            'branch' => new BranchResource($this->whenLoaded('branch')),
            'warehouse' => new WarehouseResource($this->whenLoaded('warehouse')),
            'worker' => new WorkerResource($this->whenLoaded('worker')),
            'items' => ShipmentItemResource::collection($this->whenLoaded('items')),
            'from' => $this->from,
            'to' => $this->to,
            'type' => new ShipmentTypeResource($this->whenLoaded('type')),
            'payment_method' => new PaymentMethodResource($this->whenLoaded('paymentMethod')),
            'total_tax' => $this->total_tax,
            'total_discount' => $this->total_discount,
            'total_cost' => $this->total_cost,
            'notes' => $this->notes,
            'status' => $this->status,
            'date' => $this->created_at,
        ];
        if ($this->rejectedShipment) {
            $data['reason'] = $this->rejectedShipment->reason;
        }
        return $data;
    }
}
