<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StockTransferResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'product_id' => ProductResource::make($this->whenLoaded('product')),
            'from_warehouse' => WarehouseResource::make($this->whenLoaded('fromWarehouse')),
            'from_branch' => BranchResource::make($this->whenLoaded('fromBranch')),
            'to_warehouse' => WarehouseResource::make($this->whenLoaded('toWarehouse')),
            'to_branch' => BranchResource::make($this->whenLoaded('toBranch')),
            'quantity' => $this->quantity,
        ];
    }
}
