<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubscriptionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'start_date' => $this->start_date,
            'end_date' => $this->end_date,
            'status' => $this->status,
            'price' => $this->price,
            'payment_status' => $this->payment_status,
            'payment_reference_id' => $this->payment_reference_id,
            'package' => PackageResource::make($this->whenLoaded('package')),
        ];
    }
}
