<?php

namespace App\Http\Resources;

use App\Http\Resources\EmployeeResource;
use App\Http\Resources\VacationResource;
use Illuminate\Http\Resources\Json\JsonResource;

class VacationRequestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'from' => $this->from,
            'to' => $this->to,
            'employee_id' => $this->employee_id,
            'status' => $this->status,
            'reason' => $this->reason,
            'employee' => new EmployeeResource($this->whenLoaded('employee')),
        ];
    }
}
