<?php

namespace App\Http\Services\Attendance;


use Carbon\Carbon;
use App\Models\Attendance;
use App\Models\Departure;

class AttendanceService
{
   

    public static function mySchedule($request,$employee=null): array
    {
        
    // Determine the month and year from the request
    $month = $request->query("month");
    $year = $request->query("year");

    // If month and year are provided, get the start and end dates for the period
    if ($month && $year) {
        $startDate = Carbon::create($year, $month, 1)->startOfMonth();
        $endDate = Carbon::create($year, $month, 1)->endOfMonth();
    } else {
        // If no month or year is provided, get the current month and year
        $startDate = Carbon::now()->startOfMonth();
        $endDate = Carbon::now()->endOfMonth();
    }

    // Retrieve attendance data for the specified period
    if($employee){
    $attendances = Attendance::where('employee_id', $employee)
        ->whereBetween('start_date', [$startDate, $endDate])
        ->get()
        ->keyBy(function ($item) {
            return Carbon::parse($item->start_date)->format('Y-m-d');
        });
    }else{
        $attendances = Attendance::
        whereBetween('start_date', [$startDate, $endDate])
        ->get()
        ->keyBy(function ($item) {
            return Carbon::parse($item->start_date)->format('Y-m-d');
        });
    }
//get all abesence and attendance days
     $scheduleDays=self::addEmptyDays($startDate, $endDate,$attendances);

 

   

    return $scheduleDays;

    }

    private static function addEmptyDays($startDate,$endDate,$attendances):array{
        // Generate a complete range of dates
    $dates = [];
    $currentDate = $startDate->copy();
    // dd($currentDate);

    while ($currentDate <= $endDate) {
        $formattedDate = $currentDate->format('Y-m-d');
        $attendance = $attendances->get($formattedDate);

        

        $dates[] = [
            'id' => $attendance->id ?? null,
            "name" =>$attendance->employee->name ?? "",
            "branch" =>$attendance->branche->name?? "",
            "method" =>$attendance->method ?? "",
            'attendance_date' => $formattedDate,
            'day' => $currentDate->translatedFormat('l'),
            // "depture_date" =>$this->end_date,
             "attendance_time" =>$attendance ? ($attendance->start_time ? Carbon::parse($attendance->start_time)->format('H:i') : "") : "" ,
             "departure_time" =>$attendance ? ($attendance->end_time ? Carbon::parse($attendance->end_time)->format('H:i') : "") : "" ,
            "over_time" =>$attendance->over_time ?? "",
           'image' => $attendance->image ?? ''
        ];

        $currentDate->addDay();
    }
    return $dates;

    }

}
