<?php

namespace App\Http\Services\Bill;

use App\Models\Bill;
use App\Models\Branch;
use App\Models\Client;
use App\Trait\BillTrait;
use App\Models\Warehouse;
use App\Models\PaymentMethod;
use App\Models\BillSellNature;
use App\Models\MainSellNature;
use App\Trait\UploadFileTrait;
use App\Models\BillPaymentMethod;
use App\Models\Product;
use App\Models\Tax;
use App\Http\Helper\CompanyHelper;
use App\Models\BillExpensePayment;
use App\Http\Services\Bill\BillServiceService;
use Illuminate\Validation\ValidationException;

class BillService
{
    use UploadFileTrait, BillTrait;

    public Bill $bill;
    public Warehouse $warehouse;
    public Branch $branch;
    public BillProductService $billProductService;
    public BillServiceService $billServiceService;


    public float $total = 0;


    public float $otherExpensesTotal = 0;
    public array $otherExpenses = [];

    public float $productsCost = 0;
    public float $servicesCost = 0;
    public float $discount = 0;
    public $totalDiscountOnTheBill = 0;
    public float $tax = 0;

    public bool $billWithProducts;
    public bool $billWithServices;
    public bool $processTypeUpdate;
    public bool $fastSales;
    public float $remain;

    public function billProcess($request, string $type, $billType): self
    {

        $this->billWithProducts = self::requestHave(request: $request, value: 'bill_products');
        $this->billWithServices = self::requestHave(request: $request, value: 'services');

        $this->processTypeUpdate = $type === 'update';
        $this->fastSales = $request->fast_sales;
        $this->processTypeUpdate ? $this->processProductsServicesOnUpdate() : null;

        $this->warehouse = self::getWarehouse(warehouseId: $request['bill_details']['warehouse_id']);
        $this->branch = self::getBranch(branchId: $request['bill_details']['branch_id']);

        if ($this->billWithProducts) {
            $this->initializeBillProductService(billProductsData: $request['bill_products'], warehouse: $this->warehouse);
        }

        if ($this->billWithServices) {
            $this->initializeBillServiceService(billServicesData: $request['services']);
        }


        $this->calcTotalDiscountOnBill($request->bill_details['total_bill_discount']);
// dd($this->billProductService->total);
        $this->updateProperties();
// dd($this->billProductService->total);
        $this->manageBill($request['bill_products'],billData: array_merge($request->bill_details, ['category' => $billType]))
            ->manageBillPayment(billPaymentMethods: $request->validated()['bill_payment_methods']);

       

        isset($request->expenses) ? $this->createBillOtherExpenses($request->expenses)->manageExpensePayment($request->all()['expenses_payment']) : null;

        if ($this->billWithServices) {
            $this->billServiceService->setBill(bill: $this->bill)->processRequestedServices();
        }

        if ($this->billWithProducts) {
            $this->billProductService->calcProductOtherExpensesShare($this->otherExpensesTotal)->setBill(bill: $this->bill)->processRequestedProducts();
        }
// dd($this->billProductService->total);
        $this->calcTotalDiscountOnBill($request->bill_details['total_bill_discount'], false);
        if ($request->isSalesBill()) {
            $this->manageBillSellNature(sellingNatureData: $request->validated()['bill_sell_nature']);
        }


        if ($this->bill->isAccredited()) {
            $this->updateProductQuantitiesAndDismissalNotices();
        }
        if ($this->checkSpecialClient($request['bill_details']['customer_id']) && $this->calculateRemainingAmount($request['bill_details']['amount_paid']) > 0) {

            throw ValidationException::withMessages([
                'error' => __('constants.cash_client_remain')
            ]);
        }

        return $this;
    }

    public function manageBillPayment(array $billPaymentMethods): self
    {
    foreach ($billPaymentMethods as $billPaymentMethod) {
       $payment_method = PaymentMethod::find($billPaymentMethod['payment_method']);
    //   dd( $billPaymentMethod);
            $payment_id = $billPaymentMethod['id'] ?? null;
            // dd( $billPaymentMethod['id']);
            $values =  $this->prepareValues(data: $billPaymentMethod, key: 'payment_method');

            $amount = $billPaymentMethod['amount'];

        $paymentData = [
            'bill_id' => $this->bill->id,
            'payment_method_id' => $payment_method->id,
            'payment_type' => $payment_method->model,
            'payment_id' => $payment_id,
            'resource' => $payment_method->resource,
            'value' => $values,
            'amount' => $amount,
        ];

        if ($this->processTypeUpdate) {
           
            BillPaymentMethod::updateOrCreate(
              ['bill_id' => $this->bill->id,
                 'payment_id' => $payment_id],
                $paymentData
            );
        } else {
            BillPaymentMethod::create($paymentData);
        }

    }

        return $this;
    }

    public function manageExpensePayment(array $expensesPaymentData): self
    {
        $payment_method = PaymentMethod::find($expensesPaymentData['payment_method']);

        throw_if(
            !isset($expensesPaymentData['id']),
            ValidationException::withMessages(['payment_id' => [__('validation.exists')]])
        );

        $values =  $this->prepareValues(data: $expensesPaymentData, key: 'payment_method');

        $paymentData = [
            'bill_id' => $this->bill->id,
            'payment_method_id' => $payment_method->id,
            'payment_type' => $payment_method->model,
            'payment_id' => $expensesPaymentData['id'],
            'resource' => $payment_method->resource,
            'value' => $values,
        ];

        if ($this->processTypeUpdate) {
            BillExpensePayment::updateOrCreate(
                ['bill_id' => $this->bill->id],
                $paymentData
            );
        } else {
            BillExpensePayment::create($paymentData);
        }

        return $this;
    }

    public function manageBillSellNature(array $sellingNatureData): self
    {

        $sellNature = MainSellNature::find($sellingNatureData['bill_sell_nature']);
        $selling_id = $sellingNatureData['id'] ?? null;
        $values =  $this->prepareValues(data: $sellingNatureData, key: 'bill_sell_nature');

        $sellNatureData = [
            'bill_id' => $this->bill->id,
            'main_sell_nature_id' => $sellNature->id,
            'resource' => $sellNature->resource,
            'model' => $sellNature->model,
            'selling_type' => $sellNature->model,
            'selling_id' => $selling_id,
            'value' => $values,
        ];

        if ($this->processTypeUpdate) {
            BillSellNature::updateOrCreate(
                ['bill_id' => $this->bill->id],
                $sellNatureData
            );
        } else {
            BillSellNature::create($sellNatureData);
        }


        return $this;
    }

    public function manageBill($test,array $billData): self
    {

// dd($this->totalPurchase($test));

 
        $this->remain = $this->calculateRemainingAmount(paid_amount: $billData['amount_paid']);
        //   dd( $billData['amount_paid']);

        if ($this->remain < -5) {

            throw ValidationException::withMessages([
                'bill_details.amount_paid' => [__('constants.remain_validation_message')]
            ]);
        }
        // throw amount to other revenues
        $file = isset($billData['attachment_file']) ? $this->uploadFile(Bill::FILE_PATH, $billData['attachment_file'], $this->processTypeUpdate ? $this->bill->attachment_file : null) : null;
        $billAttributes = [
            'remain' =>  $this->remain,
            'tax_amount' => $this->tax,
            'before_discount' => $this->total + $this->tax,
            'total_discount' => $this->discount + $this->totalDiscountOnTheBill,
            'amount_paid'  =>$billData['amount_paid'] ?$billData['amount_paid'] : 0,
            'attachment_file' => $file,
            'worker_id' => auth('worker')->user()?->id,
            'fast_sales' => $this->fastSales,
            'total_purchase' => $this->totalPurchase($test),

        ] + $billData;

        if ($this->processTypeUpdate) {
            $this->bill->update($billAttributes);
        } else {
            $this->bill = CompanyHelper::getCompany(request())->bills()->create($billAttributes);

        }

        return $this;
    }

    public function totalPurchase($requestedProductsData)
{
    $this->purchaseTotal = 0;
    $totalDiscount = 0; // Accumulate total discount
    $totalTax = 0; // Accumulate total tax
if($requestedProductsData){
    

    foreach ($requestedProductsData as $billProduct) {
        // Fetch product and ensure it's not stock-related
        $product = Product::where("id", $billProduct['product_id'])
                          ->where("is_stock", "=", 0)
                          ->first();

        if ($product) {
            // Calculate product total (price * quantity)
            $productTotal = $billProduct['quantity'] * $billProduct['price'];
            // dd( $productTotal);

            // Calculate discount
            if ($billProduct['discount_type'] === "percentage") {
                $discount = $productTotal * ($billProduct['discount'] / 100);
            } else {
                $discount = $billProduct['discount'];
            }
            $totalDiscount += $discount;

            // Fetch tax details
            $tax = Tax::find($billProduct['tax_id']);
            $productTax = 0;

            if ($tax) {
                if ($billProduct['tax_included']) {
                    // Calculate tax included in price
                    $productTax = ($billProduct['price'] * $tax->rate) / (100 + $tax->rate) * $billProduct['quantity'];
                  
                } else {
                    // Calculate tax excluded from price
                    $productTax = $billProduct['price'] * ($tax->rate / 100) * $billProduct['quantity'];
                }
            }
            $totalTax += $productTax;
            // dd( $productTotal);
if ($billProduct['tax_included']) {
    // $productTotal=$productTotal- $productTax;
      $this->purchaseTotal += ($productTotal - $productTax - $discount);
}else{
     $this->purchaseTotal += ($productTotal  - $discount);
    
}

        }
    }
}

    // Return the final purchase total
    return $this->purchaseTotal;
}


    public function processProductsServicesOnUpdate(): self
    {
        $this->bill->billProducts()->delete();
        $this->bill->billServices()->delete();
        $this->bill->billExpenses()->delete();
        return $this;
    }

    public function checkSpecialClient($id)
    {
        return Client::where('id', $id)->where('special', true)->exists();
    }
}
