<?php

namespace App\Http\Services;
use App\Http\Helper\AccountHelper;
use App\Http\Services\Account\AccountService;
use App\Http\Services\Account\JournalService;
use App\Models\Warehouse;

class ProductsImportService
{
    public array $warehouesesData = [];


    public function addProductsWarehousesData($warehouseId, $totalCost)
    {
        if (isset($this->warehouesesData[$warehouseId])) {
            $this->warehouesesData[$warehouseId] += $totalCost;
        } else {
            $this->warehouesesData[$warehouseId] = $totalCost;
        }
    }

    public function getimportEntries()
    {
        $entries = [
            'debit' => [],
            'credit' => [],
        ];
        $totalPrice = 0;
        foreach ($this->warehouesesData as $warehouseId => $totalCost) {
            $totalPrice += $totalCost;
            $entries['debit'][] =
                [
                    'account' => Warehouse::find($warehouseId)->account,
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $totalCost,
                    'entry_type' => "debit",
                ];
        }
        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_OPEN_BALANCE, 'Inventory'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $totalPrice,
                'entry_type' => "credit",
            ];
        return $entries;
    }
    public function createImportJournal()
    {
        $entries = $this->getimportEntries();
        JournalService::createJournal(
            date: now(),
            type: __('constants.auto_type'),
            source: 'Sales bill',
            description: __('messages.payment_for_expenses'),
            file: null,
            employee: null,
            status: true,
            debit: $entries['debit'],
            credit: $entries['credit'],
            journalable: null,
            branch: null,
            warehouse: null,
        );
    }
}
