<?php

namespace  App\Http\Services;


class  SmsaService
{


    private $_apiUrl = "http://track.smsaexpress.com/SECOM/SMSAwebService.asmx";
    private $_passkey = 'sav@9165';
    private $_sender_name;
    private $_contact_person;
    private $_POBox;
    private $_address;
    private $_sender_country;
    private $_sender_city;
    private $_sender_phone;
    private $_shipping_type;


    public function __construct()
    {
        $this->_sender_name     = env('smsa.sender_name');
        $this->_contact_person  = env('smsa.contact_person');
        $this->_POBox           = env('smsa.POBox');
        $this->_address         = env('smsa.address');
        $this->_sender_country  = env('smsa.sender_country');
        $this->_sender_city     = env('smsa.sender_city');
        $this->_sender_phone    = env('smsa.sender_phone');
        $this->_shipping_type   = env('smsa.shipping_type');
    }

    public function Shipping($parameters_array, $shipment)
    {

        $variables = array(
            'passKey'       => $this->_passkey,
            'sentDate'      => date('Y/m/d'),
            'shipType'      => 'DLV',
            'sName'         => $shipment->sender_name,
            'sContact'      => ' ',
            'sAddr1'        => $shipment->sender_address,
            'sAddr2'        => ' ',
            'sCity'         => $shipment->sender_country,
            'sPhone'        => $shipment->sender_phone,
            'sCntry'        => $shipment->sender_region,
        );

        $xml = $this->createXml('addShip', array_merge($parameters_array, $variables));

        $result = $this->send($xml);

        if (isset($result->Body->addShipResponse))
            $response = (array) $result->Body->addShipResponse->addShipResult;
        else
            $response = (array) $result->Body->Fault->faultstring;

        if (is_numeric($response[0])) {
            return ['status' => true, 'value' => $response[0]];
        } else {
            return ['status' => false, 'value' => $response[0]];
        }
    }

    public function PrintAWB($awb_no)
    {
        $variables = array(
            'awbNo'         => $awb_no,
            'passKey'       => $this->_passkey
        );

        $xml = $this->createXml('getPDF', $variables);
        $result = $this->send($xml);


        $response = (array) $result->Body->getPDFResponse;

        if (!empty($response) && isset($response['getPDFResult'])) {
            file_put_contents(public_path('smsa_labels/' . $awb_no . '.pdf'), base64_decode($response['getPDFResult']));
            return ['status' => true, 'value' => 'public/smsa_labels/' . $awb_no . '.pdf'];
        } else {
            return ['status' => false, 'value' => ''];
        }
    }

    public function Tracking($awb_no)
    {
        $variables = array(
            'awbNo'      => $awb_no,
            'passkey'       => (string)  $this->_passkey,
        );
        $xml = $this->createXml('getTrack', $variables);
        $result = $this->send($xml);

        $response =  $result->Body;

        dd($response, $result, $xml);

        if (isset($response['getTrackResponse'])) {
            $array = (array) $result->Body->getTrackResponse->getTrackResult->TrackDetailsList->TrackDetails;

            return ['status' => true, 'value' => $array];
        } else {
            $msg = (array) $response['Fault']->faultstring;
            return ['status' => false, 'value' => $msg[0]];
        }
    }

    public function Cancel($awb_no, $reason)
    {
        $variables = array(
            'awbNo'     => $awb_no,
            'passkey'   => $this->_passkey,
            'reas'      => $reason
        );
        $data = $this->createXml('cancelShipment', $variables);
        $result = $this->send($data);
        $response = (array) $result->Body;
        $response = (array) $result->Body->cancelShipmentResponse->cancelShipmentResult;
        if ($response[0] == 'Success Cancellation ') {
            return ['status' => true, 'value' => $response[0]];
        } else {
            return ['status' => false, 'value' => $response[0]];
        }
    }

    public function getStatus($awb_no)
    {
        $variables = array(
            'awbNo'    => $awb_no,
            'passkey'   => $this->_passkey,

        );
        $data = $this->createXml('getShipUpdates', $variables);
        $result = $this->send($data);
        $response = (array) $result->Body;

        if (isset($response['getTrackResponse'])) {
            $array =  $result->Body->getStatusResponse->getStatusResult;

            return ['status' => true, 'value' => $array];
        } else {
            $msg = (array) $response['Fault']->faultstring;
            return ['status' => false, 'value' => $msg[0]];
        }
    }

    private function createXml($method, $variables)
    {

        $xmlcontent = '<?xml version="1.0" encoding="utf-8"?>
          <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
            <soap:Body>
              <' . $method . ' xmlns="http://track.smsaexpress.com/secom/">';
        if (count($variables)) {
            foreach ($variables as $key => $val) {
                $xmlcontent .= '<' . $key . '>' . $val . '</' . $key . '>';
            }
        }
        $xmlcontent .= '</' . $method . '>
            </soap:Body>
          </soap:Envelope>';

        $headers = array(

            "POST /SECOM/SMSAwebService.asmx HTTP/1.1",
            "Host: track.smsaexpress.com",
            "Content-Type: text/xml; charset=utf-8",
            "SOAPAction: http://track.smsaexpress.com/secom/" . $method
        );

        return array(
            'xml'       => $xmlcontent,
            'header'    => $headers
        );
    }

    public function send(array $data)
    {
        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $data['header']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $this->_apiUrl);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data['xml']);
        $content = curl_exec($ch);

        $clean_xml = str_ireplace(['SOAP-ENV:', 'SOAP:'], '', $content);
        $xml = simplexml_load_string($clean_xml);

        return $xml;
    }
}
