<?php

namespace App\Imports;

use App\Http\Helper\CompanyHelper;
use App\Models\Category;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;
use Maatwebsite\Excel\Concerns\WithStartRow;

class CategoryImport implements ToModel, WithStartRow
{


    public function startRow(): int
    {
        return 2;
    }
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        $validator = Validator::make($row, [
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            throw new ValidationException($validator);
        }

        $category = new Category([
            'fast' => self::getTrueOrFalseFromText($row[2]),
            'status' => self::getTrueOrFalseFromText($row[3]),
            'type' => 'products_category',
            'internet_description' => '',
            'company_id' => CompanyHelper::getId()
        ]);
        $category->setTranslations('name', [
            'ar' => $row[0],
            'en' => $row[0],
        ]);
        $category->setTranslations('description', [
            'ar' => $row[1],
            'en' => $row[1],
        ]);
        $category->save();
    }
    private function getTrueOrFalseFromText($text = null): int
    {
        return $text === 'نعم' ? 1 : 0;
    }
}
