<?php

namespace App\Imports;

use App\Models\Supplier;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Http\Helper\CompanyHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class SuppliersImport implements ToModel , WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        $validator = Validator::make($row, [
            'name' => 'required',
            'phone' => 'required',
        ]);

        if ($validator->fails()) {
            throw new ValidationException($validator);
        }

        if (Supplier::where('phone', $row['phone'])->first()) {
            return null;
        }
        return new Supplier([
            'name' => $row['name'],
            'phone' => $row['phone'],
            'code' => (Supplier::latest()->first()->code ?? 100) + 1,
            'company_id' => CompanyHelper::getId(),
        ]);
    }

}
