<?php

namespace App\Jobs;

use App\Models\Branch;
use App\Models\Journal;
use App\Models\Product;
use App\Models\Warehouse;
use App\Models\ProductUnit;
use Illuminate\Bus\Queueable;
use App\Models\ProductQuantityTrack;
use App\Models\ProductWarehouse;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class ProductTrackQuantity implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        public float $quantity,
        public Journal $journal,
        public Product $product,
        public ProductWarehouse $productWarehouse,
        public ProductUnit $productUnit,
    ) {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        ProductQuantityTrack::create(
            [
                'quantity' => $this->quantity,
                'product_id' => $this->product->id,
                'journal_id' => $this->journal->id,
                'product_unit_id' => $this->productUnit->id,
                'product_warehouse_id' => $this->productWarehouse->id,
            ]
        );
    }
}
