<?php

namespace App\Jobs;

use Carbon\Carbon;
use App\Mail\OtpMail;
use App\Models\UserOtp;
use Illuminate\Support\Str;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendOtpEmailVerification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(public string $email)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $otpCode = self::generateRandomCode();

        UserOtp::create([
            'code' => $otpCode,
            'email' => $this->email,
            'expire_at' => Carbon::now()->addMinutes(5),
        ]);

        Mail::to($this->email)->send(new OtpMail($otpCode));
    }

    private static function generateRandomCode()
    {
        $code = Str::random(8);

        $isUnique = false;

        while (!$isUnique) {
            $existingUser = UserOtp::where('code', $code)->exists();

            if (!$existingUser) {
                $isUnique = true;
            } else {
                $code = Str::random(8);
            }
        }

        return $code;
    }
}
