<?php

namespace App\Jobs;

use Illuminate\Support\Str;
use Illuminate\Bus\Queueable;
use App\Mail\OtpMailForgetPassword;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendOtpEmailForgetPassword extends SendOtpEmailVerification
{
    public function handle(): void
    {
        $otpCode = self::generateCode($this->email);
        Mail::to($this->email)->send(new OtpMailForgetPassword($otpCode));
    }
}
