<?php

namespace App\Listeners;

use App\Http\Services\Account\AccountService;
use App\Models\Level;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class CompanyMainAccounts
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $first_level = Level::first(['id']);
        $main_accounts = [
            [
                'name' => [
                    'ar' => 'الأصول',
                    'en' => 'Assets',
                ],
                'description' => [
                    'ar' => 'وصف للأصول',
                    'en' => 'Assets Description',
                ],
                'code' => '1',
                'type' => 'debit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
                'level_id' => $first_level->id,
            ],
            [
                'name' => [
                    'ar' => 'الالتزامات',
                    'en' => 'Commitments',
                ],
                'description' => [
                    'ar' => 'وصف الالتزامات',
                    'en' => 'Commitments Description',
                ],
                'code' => '2',
                'type' => 'credit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
                'level_id' => $first_level->id,
            ],
            [
                'name' => [
                    'ar' => 'حقوق الملكية',
                    'en' => 'Property rights',
                ],
                'description' => [
                    'ar' => 'وصف حقوق الملكية',
                    'en' => 'Property right Description',
                ],
                'code' => '3',
                'type' => 'credit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
                'level_id' => $first_level->id,
            ],
            [
                'name' => [
                    'ar' => 'الايرادات',
                    'en' => 'revenues',
                ],
                'description' => [
                    'ar' => 'وصف الايرادات',
                    'en' => 'revenues Description',
                ],
                'code' => '4',
                'type' => 'credit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
                'level_id' => $first_level->id,
            ],
            [
                'name' => [
                    'ar' => 'مصاريف',
                    'en' => 'expenses',
                ],
                'description' => [
                    'ar' => 'وصف مصاريف',
                    'en' => 'expenses Description',
                ],
                'code' => '5',
                'type' => 'debit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
                'level_id' => $first_level->id,
            ],

        ];
        $child_accounts = [
            [
                [
                    'name' => [
                        'ar' => 'الأصول المتداولة',
                        'en' => 'Current Assets',
                    ],
                    'description' => [
                        'ar' => 'وصف للاصول المتداولة',
                        'en' => 'Current Assets Description',
                    ],
                    'type' => 'debit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'الأصول الغير المتداولة',
                        'en' => 'Non-current Assets',
                    ],
                    'description' => [
                        'ar' => 'وصف الغير المتداولة',
                        'en' => 'Non-current Assets Description',
                    ],
                    'type' => 'debit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
            ],
            [
                [
                    'name' => [
                        'ar' => 'الالتزامات المتداولة',
                        'en' => 'Current Commitments',
                    ],
                    'description' => [
                        'ar' => 'وصف للاصول المتداولة',
                        'en' => 'Current Commitments Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'الالتزامات الغير المتداولة',
                        'en' => 'Non-current Commitments',
                    ],
                    'description' => [
                        'ar' => 'وصف الغير المتداولة',
                        'en' => 'Non-current Commitments Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
            ],
            [
                [
                    'name' => [
                        'ar' => 'رأس المال',
                        'en' => 'Capital',
                    ],
                    'description' => [
                        'ar' => ' وصف رأس المال',
                        'en' => 'Capital Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'حقوق ملكية أخرى',
                        'en' => 'Other Property Rights',
                    ],
                    'description' => [
                        'ar' => 'وصف حقوق ملكية أخرى ',
                        'en' => 'Other Property Rights Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'الأحتياطات',
                        'en' => 'Reserves',
                    ],
                    'description' => [
                        'ar' => 'وصف الأحتياطات',
                        'en' => 'Reserves Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'الأرباح المبقاة او (الخسائر)',
                        'en' => 'Retained Earnings or (Losses)',
                    ],
                    'description' => [
                        'ar' => 'وصف الأرباح المبقاة او (الخسائر)',
                        'en' => 'Retained Earnings or (Losses) Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ]
            ],
            [
                [
                    'name' => [
                        'ar' => 'الايرادات التشغيلية',
                        'en' => 'Operating Revenues',
                    ],
                    'description' => [
                        'ar' => 'وصف الايرادات التشغيلية',
                        'en' => 'Operating Revenues Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'الايرادات غير التشغيلية',
                        'en' => 'Non-operating Revenues',
                    ],
                    'description' => [
                        'ar' => 'وصف الايرادات غير التشغيلية',
                        'en' => 'Non-operating Revenues Description',
                    ],
                    'type' => 'credit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
            ],
            [
                [
                    'name' => [
                        'ar' => 'تكاليف مباشرة',
                        'en' => 'Direct Costs',
                    ],
                    'description' => [
                        'ar' => 'وصف التكاليف المباشرة',
                        'en' => 'Direct Costs Description',
                    ],
                    'type' => 'debit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'التكاليف التشغيلية',
                        'en' => 'Operating Costs',
                    ],
                    'description' => [
                        'ar' => 'وصف التكاليف التشغيلية',
                        'en' => 'Operating Costs Description',
                    ],
                    'type' => 'debit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
                [
                    'name' => [
                        'ar' => 'التكاليف غير التشغيلية',
                        'en' => 'Non-operating Costs',
                    ],
                    'description' => [
                        'ar' => 'وصف التكاليف غير التشغيلية',
                        'en' => 'Non-operating Costs Description',
                    ],
                    'type' => 'debit',
                    'status' => 'main',
                    'active' => true,
                    'amount' => 0,
                ],
            ],
        ];
        foreach ($main_accounts as  $index => $account) {
            //To Create First level accounts
            $createdAccount = $event->company->accounts()->create($account);
            //To Create Second level accounts (Children of First Level)
            foreach ($child_accounts[$index] as $child_account) {
                $child_account['parent_id'] = $createdAccount->id;
                $child_account['code'] = AccountService::generateCode($createdAccount);
                $child_account['level_id'] = AccountService::$nextLevel->id;
                $event->company->accounts()->create($child_account);
            }
        }
    }
}
