<?php

namespace App\Listeners;

use App\Events\GroupSettingEvent;
use App\Models\BranchSubSettings;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class GroupSubSetting
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(GroupSettingEvent $event)
    {
        $sub_settings = BranchSubSettings::get();
        foreach ($sub_settings as $setting)
        {
            $event->groupSetting->subSettings()->create([
                'branch_sub_settings_id' => $setting->id,
                'value' => "null",
            ]);
        }
    }
}
