<?php

namespace App\Listeners;

use App\Events\NewCompany;
use App\Http\Helper\CompanyHelper;
use App\Jobs\SendOtpEmailVerification;
use App\Models\UserOtp;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendEmailOtp
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewCompany $event): void
    {
        UserOtp::where('email', $event->company->email)->delete();
        SendOtpEmailVerification::dispatch($event->company->email);

        $event->company->secret_key = CompanyHelper::createSecretKey();
        $event->company->save();
    }
}
