<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Advantage extends Model
{
    use HasFactory, HasTranslations;
    public $translatable = ['title', "content", "description"];
    protected $fillable = [
        'title',
        'image',
        'content',
        'type',
        'description',
    ];

    const UPLOADED_FILES = 'uploads/advantages';





    public function getImagePathAttribute($value)
    {
        return  $this->image  ? asset('public/' . self::UPLOADED_FILES . '/' . $this->image) : null;
    }
}
