<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AutoShiftDetails extends Model
{
    use HasFactory;

    protected $fillable = [
        'worker_id',
        'auto_shift_id',
        'treasury_id',
        'amount',
    ];

    public function worker()
    {
        return $this->belongsTo(Worker::class);
    }

    public function autoShift()
    {
        return $this->belongsTo(AutoShift::class);
    }

    public function treasury()
    {
        return $this->belongsTo(Treasury::class);
    }
}
