<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillExpensePayment extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_id',
        'payment_method_id',
        'payment_type',
        'payment_id',
        'resource',
        'value',
    ];

    protected $casts = [
        'value' => 'json',
    ];

    public function payment()
    {
        return $this->morphTo('payment');
    }

    public function bill()
    {
        return $this->belongsTo(Bill::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
}
