<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillPaymentMethod extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_id',
        'payment_method_id',
        'payment_type',
        'payment_id',
        'resource',
        'value',
        'amount',
        'payment_method_type_id',
        'phone',
    ];

    protected $casts = [
        'value' => 'json',
    ];

    public function payment()
    {
        return $this->morphTo('payment');
    }

    public function bill()
    {
        return $this->belongsTo(Bill::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
    public function paymentMethodType()
    {
        return $this->belongsTo(paymentMethodType::class);
    }
}
