<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlockClient extends Model
{
    use HasFactory;

    const ROLE = [
        'client_id' => 'required|exists:clients,id|unique:block_clients,client_id',
        'reason_id' => 'required|exists:dropdown_options,id',
        'note' => 'required',
        'date' => 'required',
        'status' => 'required',
    ];

    protected $fillable = [
        'company_id',
        'client_id',
        'reason_id',
        'note',
        'date',
        'status',
    ];

    public function blockReason()
    {
        return $this->belongsTo(BlockReason::class, 'reason_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
