<?php

namespace App\Models;

use App\Http\Enums\Bound\BoundTypeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Bound extends Model
{
    use HasFactory, SoftDeletes;

    const FILE_PATH = 'uploads/company/bounds';

    protected $fillable = [
        'type', // Payments - Receivables
        'date',
        'voucher_type',
        'description',
        'company_id',
        'branch_id',
        'payment_method_id', // use in payment method
        'payment_type', // use in payment method
        'payment_id', // use in payment method
        'resource', // use in payment method
        'ref_number', // used in Payments type
        'status', // used in Payments type

    ];
    protected $with = ['boundEntries'];

    protected $casts = [
        'type' => BoundTypeEnum::class,
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function payment()
    {
        return $this->morphTo('payment');
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function journals()
    {
        return $this->morphMany(Journal::class, 'journalable');
    }

    public function boundEntries()
    {
        return $this->hasMany(BoundEntries::class, 'bound_id');
    }

    public function getValueAttribute()
    {
        return $this->boundEntries()->sum('value');
    }
    public function entry()
    {
        return $this->morphTo('entry');
    }
    
    public function bills()
    {
        return $this->belongsToMany(Bill::class, 'bound_bill')
                    ->withPivot('amount', 'discount')
                    ->withTimestamps();
    }
    
    public function scopeArchived($query)
    {
        return $query->onlyTrashed();
    }

    
}
