<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BranchSubSettings extends Model
{
    use HasFactory, HasTranslations;

    const BOOL = 1;
    const STRING = 2;
    const INT = 3;
    const ENUM = 4;

    protected $fillable = [
        'name',
        'type',
        'branch_main_settings_id',
        'roles',
    ];

    public $translatable = [
        'name',
    ];

    public function mainSetting()
    {
        return $this->belongsTo(BranchMainSettings::class);
    }
}
