<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BranchUnit extends Model
{
    use HasFactory;
    protected $fillable = [
        'unit_id',
        'selling_price',
        'purchasing_price',
        'product_branch_id',
    ];

    public function productBranch()
    {
        return $this->belongsTo(ProductBranch::class);
    }

    public function unit()
    {
        return $this->belongsTo(CompanyUnit::class, 'unit_id');
    }
}
