<?php

namespace App\Models;

use App\Models\Service;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Category extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'type',
        'name',
        'description',
        'internet_description',
        'status',
        'fast',
        'company_id',
    ];

    const RULES = [
        'type' => 'required|in:products_category,services_category',
        'name' => 'nullable',
        'name_ar' => 'required',
        'name_en' => 'nullable',
        'description'=> 'nullable',
        'description_ar' => 'required',
        'description_en' => 'nullable',
        'internet_description' => 'required',
        'status' => 'required',
        'fast' => 'required',
        'company_id' => 'required|exists:companies,id',

    ];

    public $translatable = [
        'name',
        'description',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function services()
    {
        return $this->hasMany(Service::class);
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    // public function fastServices()
    // {
    //     return $this->services->where('fast', 1);
    // }
}
