<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class CompanyUnit extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULE = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'nullable|string',
        'category_id' => 'nullable',
    ];

    protected $fillable = [
        'name',
        'category_id'
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function category()
    {
        return $this->belongsTo(UnitCatogry::class,'category_id');
    }

    public function productServiceUnits()
    {
        return $this->hasMany(ProductServiceUnit::class, 'company_unit_id');
    }
}
