<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Custody extends Model
{
    use HasFactory;

    public $guarded = [];
    public $with = ['employee'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
    }
    public function custodiesTaken()
    {
        return $this->hasMany(CustodyTaken::class, 'employee_id', 'employee_id');
    }

    public function entries()
    {
        return $this->morphMany(JournalEntry::class, 'type');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
