<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustodyTaken extends Model
{
    use HasFactory;
    public $fillable = ['account_id', 'employee_id', 'amount', 'type'];
    protected $with = ['entries'];
    public function account()
    {
        return  $this->belongsTo(Account::class);
    }

    public function employee()
    {
        return  $this->belongsTo(Employee::class);
    }

    public function entries()
    {
        return $this->morphMany(JournalEntry::class, 'type');
    }
    public function journals()
    {
        return $this->morphMany(Journal::class, 'journalable');
    }

    public function custody()
    {
        return $this->belongsTo(Custody::class);
    }
}
