<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use App\Http\Enums\Package\FeatureTypeEnum;
use App\Http\Enums\Package\FeatureGroupEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Feature extends Model
{
    use HasFactory, HasTranslations;

    const FEATURE_ACCOUNTS_TREE = 'ACCOUNTS_TREE';
    const FEATURE_ACCOUNTS_SETTINGS = 'ACCOUNTS_SETTINGS';
    const FEATURE_JOURNAL_ENTRIES = 'JOURNAL_ENTRIES';
    const FEATURE_PAYMENTS_AND_RECEIVABLES = 'PAYMENTS_AND_RECEIVABLES';
    const FEATURE_CLIENTS = 'CLIENTS';
    const FEATURE_CLIENTS_SETTINGS = 'CLIENTS_SETTINGS';
    const FEATURE_SUPPLIERS = 'SUPPLIERS';
    const FEATURE_SUPPLIERS_SETTINGS = 'SUPPLIERS_SETTINGS';
    const FEATURE_PRODUCTS = 'PRODUCTS';
    const FEATURE_WAREHOUSES = 'WAREHOUSES';
    const FEATURE_SERVICES = 'SERVICES';
    const FEATURE_WAREHOUSES_SETTINGS = 'WAREHOUSES_SETTINGS';
    const FEATURE_BRANCHES = 'BRANCHES';
    const FEATURE_PURCHASES = 'PURCHASES';
    const FEATURE_SALES = 'SALES';
    const FEATURE_FAST_SALES = 'FAST_SALES';
    const FEATURE_ONLINE_SALES = 'ONLINE_SALES';
    const FEATURE_TEACHER_REPORT = 'TEACHER_REPORT';
    const FEATURE_JOURNAL_REPORT = 'JOURNAL_REPORT';
    const FEATURE_TRIAL_BALANCE = 'TRIAL_BALANCE';
    const FEATURE_WORKERS = 'WORKERS';

    protected $fillable = [
        'key',
        'name',
        'group',
        'type',
    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'group' => FeatureGroupEnum::class,
        'type' => FeatureTypeEnum::class,
    ];
}
