<?php

namespace App\Models;

use App\Http\Helper\AccountHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Journal extends Model
{
    use HasFactory;

    const UPLOADED_FILES = 'uploads/journals';

    protected $fillable = [
        'date',
        'reference_code',
        'company_id',
        'type',
        'source',
        'description',
        'file',
        'employee_id',
        'status',
        'shift_id',
        'branch_id',
        'warehouse_id',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function shift()
    {
        return $this->belongsTo(Shift::class);
    }

    public function entries()
    {
        return $this->hasMany(JournalEntry::class);
    }
    public function journalRepeation()
    {
        return $this->hasMany(JournalReptation::class);
    }

    public function journalable()
    {
        return $this->morphTo();
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function productQuantityTracks()
    {
        return $this->hasMany(ProductQuantityTrack::class);
    }

    public function scopeBillOfProduct($query, $product)
    {
        return
            $query->whereHasMorph('journalable', [Bill::class], function ($query) use ($product) {
                $query->whereHas('billProducts', function ($query) use ($product) {
                    $query->where('product_id', $product->id)
                        ->with('billProducts');
                });
            })
            ->whereHas('entries', function ($query) {
                return $query->whereHas('account', function ($query) {
                    return $query->whereHas('model', function ($query) {
                        return $query->where('name', AccountHelper::ACCOUNT_PRODUCTS);
                    });
                });
            });
    }
    public function files()
    {
    return $this->hasMany(JournalFile::class);
    }
}
